/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.ParameterNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteParametersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DeleteParametersResponse> {
    private final List<String> deletedParameters;
    private final List<String> invalidParameters;

    private DeleteParametersResponse(BuilderImpl builder) {
        this.deletedParameters = builder.deletedParameters;
        this.invalidParameters = builder.invalidParameters;
    }

    public List<String> deletedParameters() {
        return this.deletedParameters;
    }

    public List<String> invalidParameters() {
        return this.invalidParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deletedParameters() == null ? 0 : this.deletedParameters().hashCode());
        hashCode = 31 * hashCode + (this.invalidParameters() == null ? 0 : this.invalidParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteParametersResponse)) {
            return false;
        }
        DeleteParametersResponse other = (DeleteParametersResponse)((Object)obj);
        if (other.deletedParameters() == null ^ this.deletedParameters() == null) {
            return false;
        }
        if (other.deletedParameters() != null && !other.deletedParameters().equals(this.deletedParameters())) {
            return false;
        }
        if (other.invalidParameters() == null ^ this.invalidParameters() == null) {
            return false;
        }
        return other.invalidParameters() == null || other.invalidParameters().equals(this.invalidParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deletedParameters() != null) {
            sb.append("DeletedParameters: ").append(this.deletedParameters()).append(",");
        }
        if (this.invalidParameters() != null) {
            sb.append("InvalidParameters: ").append(this.invalidParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> deletedParameters;
        private List<String> invalidParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteParametersResponse model) {
            this.setDeletedParameters(model.deletedParameters);
            this.setInvalidParameters(model.invalidParameters);
        }

        public final Collection<String> getDeletedParameters() {
            return this.deletedParameters;
        }

        @Override
        public final Builder deletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedParameters(String ... deletedParameters) {
            this.deletedParameters(Arrays.asList(deletedParameters));
            return this;
        }

        public final void setDeletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
        }

        @SafeVarargs
        public final void setDeletedParameters(String ... deletedParameters) {
            this.deletedParameters(Arrays.asList(deletedParameters));
        }

        public final Collection<String> getInvalidParameters() {
            return this.invalidParameters;
        }

        @Override
        public final Builder invalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidParameters(String ... invalidParameters) {
            this.invalidParameters(Arrays.asList(invalidParameters));
            return this;
        }

        public final void setInvalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
        }

        @SafeVarargs
        public final void setInvalidParameters(String ... invalidParameters) {
            this.invalidParameters(Arrays.asList(invalidParameters));
        }

        public DeleteParametersResponse build() {
            return new DeleteParametersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteParametersResponse> {
        public Builder deletedParameters(Collection<String> var1);

        public Builder deletedParameters(String ... var1);

        public Builder invalidParameters(Collection<String> var1);

        public Builder invalidParameters(String ... var1);
    }
}

