/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMaintenanceWindowResponse extends SsmResponse implements
        ToCopyableBuilder<GetMaintenanceWindowResponse.Builder, GetMaintenanceWindowResponse> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMaintenanceWindowResponse::windowId)).setter(setter(Builder::windowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMaintenanceWindowResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMaintenanceWindowResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMaintenanceWindowResponse::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetMaintenanceWindowResponse::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetMaintenanceWindowResponse::cutoff)).setter(setter(Builder::cutoff))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()).build();

    private static final SdkField<Boolean> ALLOW_UNASSOCIATED_TARGETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetMaintenanceWindowResponse::allowUnassociatedTargets))
            .setter(setter(Builder::allowUnassociatedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUnassociatedTargets").build())
            .build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetMaintenanceWindowResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetMaintenanceWindowResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<Instant> MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetMaintenanceWindowResponse::modifiedDate)).setter(setter(Builder::modifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, SCHEDULE_FIELD, DURATION_FIELD, CUTOFF_FIELD, ALLOW_UNASSOCIATED_TARGETS_FIELD, ENABLED_FIELD,
            CREATED_DATE_FIELD, MODIFIED_DATE_FIELD));

    private final String windowId;

    private final String name;

    private final String description;

    private final String schedule;

    private final Integer duration;

    private final Integer cutoff;

    private final Boolean allowUnassociatedTargets;

    private final Boolean enabled;

    private final Instant createdDate;

    private final Instant modifiedDate;

    private GetMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.enabled = builder.enabled;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
    }

    /**
     * <p>
     * The ID of the created Maintenance Window.
     * </p>
     * 
     * @return The ID of the created Maintenance Window.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The name of the Maintenance Window.
     * </p>
     * 
     * @return The name of the Maintenance Window.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the Maintenance Window.
     * </p>
     * 
     * @return The description of the Maintenance Window.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The schedule of the Maintenance Window in the form of a cron or rate expression.
     * </p>
     * 
     * @return The schedule of the Maintenance Window in the form of a cron or rate expression.
     */
    public String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The duration of the Maintenance Window in hours.
     * </p>
     * 
     * @return The duration of the Maintenance Window in hours.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for
     * execution.
     * </p>
     * 
     * @return The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new
     *         tasks for execution.
     */
    public Integer cutoff() {
        return cutoff;
    }

    /**
     * <p>
     * Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.
     * </p>
     * 
     * @return Whether targets must be registered with the Maintenance Window before tasks can be defined for those
     *         targets.
     */
    public Boolean allowUnassociatedTargets() {
        return allowUnassociatedTargets;
    }

    /**
     * <p>
     * Whether the Maintenance Windows is enabled.
     * </p>
     * 
     * @return Whether the Maintenance Windows is enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The date the Maintenance Window was created.
     * </p>
     * 
     * @return The date the Maintenance Window was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date the Maintenance Window was last modified.
     * </p>
     * 
     * @return The date the Maintenance Window was last modified.
     */
    public Instant modifiedDate() {
        return modifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(allowUnassociatedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowResponse)) {
            return false;
        }
        GetMaintenanceWindowResponse other = (GetMaintenanceWindowResponse) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(duration(), other.duration()) && Objects.equals(cutoff(), other.cutoff())
                && Objects.equals(allowUnassociatedTargets(), other.allowUnassociatedTargets())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(modifiedDate(), other.modifiedDate());
    }

    @Override
    public String toString() {
        return ToString.builder("GetMaintenanceWindowResponse").add("WindowId", windowId()).add("Name", name())
                .add("Description", description()).add("Schedule", schedule()).add("Duration", duration())
                .add("Cutoff", cutoff()).add("AllowUnassociatedTargets", allowUnassociatedTargets()).add("Enabled", enabled())
                .add("CreatedDate", createdDate()).add("ModifiedDate", modifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Cutoff":
            return Optional.ofNullable(clazz.cast(cutoff()));
        case "AllowUnassociatedTargets":
            return Optional.ofNullable(clazz.cast(allowUnassociatedTargets()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "ModifiedDate":
            return Optional.ofNullable(clazz.cast(modifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMaintenanceWindowResponse, T> g) {
        return obj -> g.apply((GetMaintenanceWindowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMaintenanceWindowResponse> {
        /**
         * <p>
         * The ID of the created Maintenance Window.
         * </p>
         * 
         * @param windowId
         *        The ID of the created Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The name of the Maintenance Window.
         * </p>
         * 
         * @param name
         *        The name of the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the Maintenance Window.
         * </p>
         * 
         * @param description
         *        The description of the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The schedule of the Maintenance Window in the form of a cron or rate expression.
         * </p>
         * 
         * @param schedule
         *        The schedule of the Maintenance Window in the form of a cron or rate expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The duration of the Maintenance Window in hours.
         * </p>
         * 
         * @param duration
         *        The duration of the Maintenance Window in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks
         * for execution.
         * </p>
         * 
         * @param cutoff
         *        The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new
         *        tasks for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cutoff(Integer cutoff);

        /**
         * <p>
         * Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.
         * </p>
         * 
         * @param allowUnassociatedTargets
         *        Whether targets must be registered with the Maintenance Window before tasks can be defined for those
         *        targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets);

        /**
         * <p>
         * Whether the Maintenance Windows is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether the Maintenance Windows is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The date the Maintenance Window was created.
         * </p>
         * 
         * @param createdDate
         *        The date the Maintenance Window was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date the Maintenance Window was last modified.
         * </p>
         * 
         * @param modifiedDate
         *        The date the Maintenance Window was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedDate(Instant modifiedDate);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String windowId;

        private String name;

        private String description;

        private String schedule;

        private Integer duration;

        private Integer cutoff;

        private Boolean allowUnassociatedTargets;

        private Boolean enabled;

        private Instant createdDate;

        private Instant modifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowResponse model) {
            super(model);
            windowId(model.windowId);
            name(model.name);
            description(model.description);
            schedule(model.schedule);
            duration(model.duration);
            cutoff(model.cutoff);
            allowUnassociatedTargets(model.allowUnassociatedTargets);
            enabled(model.enabled);
            createdDate(model.createdDate);
            modifiedDate(model.modifiedDate);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return allowUnassociatedTargets;
        }

        @Override
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getModifiedDate() {
            return modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        @Override
        public GetMaintenanceWindowResponse build() {
            return new GetMaintenanceWindowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
