/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAutomationExecutionsResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeAutomationExecutionsResponse.Builder, DescribeAutomationExecutionsResponse> {
    private static final SdkField<List<AutomationExecutionMetadata>> AUTOMATION_EXECUTION_METADATA_LIST_FIELD = SdkField
            .<List<AutomationExecutionMetadata>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAutomationExecutionsResponse::automationExecutionMetadataList))
            .setter(setter(Builder::automationExecutionMetadataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionMetadataList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomationExecutionMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomationExecutionMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAutomationExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATION_EXECUTION_METADATA_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<AutomationExecutionMetadata> automationExecutionMetadataList;

    private final String nextToken;

    private DescribeAutomationExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.automationExecutionMetadataList = builder.automationExecutionMetadataList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of details about each automation execution which has occurred which matches the filter specification, if
     * any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of details about each automation execution which has occurred which matches the filter
     *         specification, if any.
     */
    public List<AutomationExecutionMetadata> automationExecutionMetadataList() {
        return automationExecutionMetadataList;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionMetadataList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutomationExecutionsResponse)) {
            return false;
        }
        DescribeAutomationExecutionsResponse other = (DescribeAutomationExecutionsResponse) obj;
        return Objects.equals(automationExecutionMetadataList(), other.automationExecutionMetadataList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAutomationExecutionsResponse")
                .add("AutomationExecutionMetadataList", automationExecutionMetadataList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionMetadataList":
            return Optional.ofNullable(clazz.cast(automationExecutionMetadataList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutomationExecutionsResponse, T> g) {
        return obj -> g.apply((DescribeAutomationExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAutomationExecutionsResponse> {
        /**
         * <p>
         * The list of details about each automation execution which has occurred which matches the filter
         * specification, if any.
         * </p>
         * 
         * @param automationExecutionMetadataList
         *        The list of details about each automation execution which has occurred which matches the filter
         *        specification, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionMetadataList(Collection<AutomationExecutionMetadata> automationExecutionMetadataList);

        /**
         * <p>
         * The list of details about each automation execution which has occurred which matches the filter
         * specification, if any.
         * </p>
         * 
         * @param automationExecutionMetadataList
         *        The list of details about each automation execution which has occurred which matches the filter
         *        specification, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionMetadataList(AutomationExecutionMetadata... automationExecutionMetadataList);

        /**
         * <p>
         * The list of details about each automation execution which has occurred which matches the filter
         * specification, if any.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutomationExecutionMetadata>.Builder}
         * avoiding the need to create one manually via {@link List<AutomationExecutionMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutomationExecutionMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #automationExecutionMetadataList(List<AutomationExecutionMetadata>)}.
         * 
         * @param automationExecutionMetadataList
         *        a consumer that will call methods on {@link List<AutomationExecutionMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automationExecutionMetadataList(List<AutomationExecutionMetadata>)
         */
        Builder automationExecutionMetadataList(Consumer<AutomationExecutionMetadata.Builder>... automationExecutionMetadataList);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<AutomationExecutionMetadata> automationExecutionMetadataList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutomationExecutionsResponse model) {
            super(model);
            automationExecutionMetadataList(model.automationExecutionMetadataList);
            nextToken(model.nextToken);
        }

        public final Collection<AutomationExecutionMetadata.Builder> getAutomationExecutionMetadataList() {
            return automationExecutionMetadataList != null ? automationExecutionMetadataList.stream()
                    .map(AutomationExecutionMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder automationExecutionMetadataList(
                Collection<AutomationExecutionMetadata> automationExecutionMetadataList) {
            this.automationExecutionMetadataList = AutomationExecutionMetadataListCopier.copy(automationExecutionMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationExecutionMetadataList(AutomationExecutionMetadata... automationExecutionMetadataList) {
            automationExecutionMetadataList(Arrays.asList(automationExecutionMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationExecutionMetadataList(
                Consumer<AutomationExecutionMetadata.Builder>... automationExecutionMetadataList) {
            automationExecutionMetadataList(Stream.of(automationExecutionMetadataList)
                    .map(c -> AutomationExecutionMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutomationExecutionMetadataList(
                Collection<AutomationExecutionMetadata.BuilderImpl> automationExecutionMetadataList) {
            this.automationExecutionMetadataList = AutomationExecutionMetadataListCopier
                    .copyFromBuilder(automationExecutionMetadataList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAutomationExecutionsResponse build() {
            return new DescribeAutomationExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
