/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePatchBaselineRequest extends SsmRequest implements
        ToCopyableBuilder<CreatePatchBaselineRequest.Builder, CreatePatchBaselineRequest> {
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePatchBaselineRequest::operatingSystemAsString)).setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePatchBaselineRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PatchFilterGroup> GLOBAL_FILTERS_FIELD = SdkField
            .<PatchFilterGroup> builder(MarshallingType.SDK_POJO).getter(getter(CreatePatchBaselineRequest::globalFilters))
            .setter(setter(Builder::globalFilters)).constructor(PatchFilterGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalFilters").build()).build();

    private static final SdkField<PatchRuleGroup> APPROVAL_RULES_FIELD = SdkField
            .<PatchRuleGroup> builder(MarshallingType.SDK_POJO).getter(getter(CreatePatchBaselineRequest::approvalRules))
            .setter(setter(Builder::approvalRules)).constructor(PatchRuleGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalRules").build()).build();

    private static final SdkField<List<String>> APPROVED_PATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreatePatchBaselineRequest::approvedPatches))
            .setter(setter(Builder::approvedPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePatchBaselineRequest::approvedPatchesComplianceLevelAsString))
            .setter(setter(Builder::approvedPatchesComplianceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesComplianceLevel")
                    .build()).build();

    private static final SdkField<List<String>> REJECTED_PATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreatePatchBaselineRequest::rejectedPatches))
            .setter(setter(Builder::rejectedPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePatchBaselineRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePatchBaselineRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATING_SYSTEM_FIELD,
            NAME_FIELD, GLOBAL_FILTERS_FIELD, APPROVAL_RULES_FIELD, APPROVED_PATCHES_FIELD,
            APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD, REJECTED_PATCHES_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));

    private final String operatingSystem;

    private final String name;

    private final PatchFilterGroup globalFilters;

    private final PatchRuleGroup approvalRules;

    private final List<String> approvedPatches;

    private final String approvedPatchesComplianceLevel;

    private final List<String> rejectedPatches;

    private final String description;

    private final String clientToken;

    private CreatePatchBaselineRequest(BuilderImpl builder) {
        super(builder);
        this.operatingSystem = builder.operatingSystem;
        this.name = builder.name;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.approvedPatchesComplianceLevel = builder.approvedPatchesComplianceLevel;
        this.rejectedPatches = builder.rejectedPatches;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
     * @see OperatingSystem
     */
    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
     * @see OperatingSystem
     */
    public String operatingSystemAsString() {
        return operatingSystem;
    }

    /**
     * <p>
     * The name of the patch baseline.
     * </p>
     * 
     * @return The name of the patch baseline.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A set of global filters used to exclude patches from the baseline.
     * </p>
     * 
     * @return A set of global filters used to exclude patches from the baseline.
     */
    public PatchFilterGroup globalFilters() {
        return globalFilters;
    }

    /**
     * <p>
     * A set of rules used to include patches in the baseline.
     * </p>
     * 
     * @return A set of rules used to include patches in the baseline.
     */
    public PatchRuleGroup approvalRules() {
        return approvalRules;
    }

    /**
     * <p>
     * A list of explicitly approved patches for the baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of explicitly approved patches for the baseline.
     */
    public List<String> approvedPatches() {
        return approvedPatches;
    }

    /**
     * <p>
     * Defines the compliance level for approved patches. This means that if an approved patch is reported as missing,
     * this is the severity of the compliance violation. Valid compliance severity levels include the following:
     * CRITICAL, HIGH, MEDIUM, LOW, INFORMATIONAL, UNSPECIFIED. The default value is UNSPECIFIED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approvedPatchesComplianceLevel} will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #approvedPatchesComplianceLevelAsString}.
     * </p>
     * 
     * @return Defines the compliance level for approved patches. This means that if an approved patch is reported as
     *         missing, this is the severity of the compliance violation. Valid compliance severity levels include the
     *         following: CRITICAL, HIGH, MEDIUM, LOW, INFORMATIONAL, UNSPECIFIED. The default value is UNSPECIFIED.
     * @see PatchComplianceLevel
     */
    public PatchComplianceLevel approvedPatchesComplianceLevel() {
        return PatchComplianceLevel.fromValue(approvedPatchesComplianceLevel);
    }

    /**
     * <p>
     * Defines the compliance level for approved patches. This means that if an approved patch is reported as missing,
     * this is the severity of the compliance violation. Valid compliance severity levels include the following:
     * CRITICAL, HIGH, MEDIUM, LOW, INFORMATIONAL, UNSPECIFIED. The default value is UNSPECIFIED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approvedPatchesComplianceLevel} will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #approvedPatchesComplianceLevelAsString}.
     * </p>
     * 
     * @return Defines the compliance level for approved patches. This means that if an approved patch is reported as
     *         missing, this is the severity of the compliance violation. Valid compliance severity levels include the
     *         following: CRITICAL, HIGH, MEDIUM, LOW, INFORMATIONAL, UNSPECIFIED. The default value is UNSPECIFIED.
     * @see PatchComplianceLevel
     */
    public String approvedPatchesComplianceLevelAsString() {
        return approvedPatchesComplianceLevel;
    }

    /**
     * <p>
     * A list of explicitly rejected patches for the baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of explicitly rejected patches for the baseline.
     */
    public List<String> rejectedPatches() {
        return rejectedPatches;
    }

    /**
     * <p>
     * A description of the patch baseline.
     * </p>
     * 
     * @return A description of the patch baseline.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * User-provided idempotency token.
     * </p>
     * 
     * @return User-provided idempotency token.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(globalFilters());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRules());
        hashCode = 31 * hashCode + Objects.hashCode(approvedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(approvedPatchesComplianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rejectedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePatchBaselineRequest)) {
            return false;
        }
        CreatePatchBaselineRequest other = (CreatePatchBaselineRequest) obj;
        return Objects.equals(operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(globalFilters(), other.globalFilters())
                && Objects.equals(approvalRules(), other.approvalRules())
                && Objects.equals(approvedPatches(), other.approvedPatches())
                && Objects.equals(approvedPatchesComplianceLevelAsString(), other.approvedPatchesComplianceLevelAsString())
                && Objects.equals(rejectedPatches(), other.rejectedPatches())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken());
    }

    @Override
    public String toString() {
        return ToString.builder("CreatePatchBaselineRequest").add("OperatingSystem", operatingSystemAsString())
                .add("Name", name()).add("GlobalFilters", globalFilters()).add("ApprovalRules", approvalRules())
                .add("ApprovedPatches", approvedPatches())
                .add("ApprovedPatchesComplianceLevel", approvedPatchesComplianceLevelAsString())
                .add("RejectedPatches", rejectedPatches()).add("Description", description()).add("ClientToken", clientToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "GlobalFilters":
            return Optional.ofNullable(clazz.cast(globalFilters()));
        case "ApprovalRules":
            return Optional.ofNullable(clazz.cast(approvalRules()));
        case "ApprovedPatches":
            return Optional.ofNullable(clazz.cast(approvedPatches()));
        case "ApprovedPatchesComplianceLevel":
            return Optional.ofNullable(clazz.cast(approvedPatchesComplianceLevelAsString()));
        case "RejectedPatches":
            return Optional.ofNullable(clazz.cast(rejectedPatches()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePatchBaselineRequest, T> g) {
        return obj -> g.apply((CreatePatchBaselineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePatchBaselineRequest> {
        /**
         * <p>
         * Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
         * </p>
         * 
         * @param operatingSystem
         *        Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
         * </p>
         * 
         * @param operatingSystem
         *        Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        /**
         * <p>
         * The name of the patch baseline.
         * </p>
         * 
         * @param name
         *        The name of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A set of global filters used to exclude patches from the baseline.
         * </p>
         * 
         * @param globalFilters
         *        A set of global filters used to exclude patches from the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalFilters(PatchFilterGroup globalFilters);

        /**
         * <p>
         * A set of global filters used to exclude patches from the baseline.
         * </p>
         * This is a convenience that creates an instance of the {@link PatchFilterGroup.Builder} avoiding the need to
         * create one manually via {@link PatchFilterGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchFilterGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #globalFilters(PatchFilterGroup)}.
         * 
         * @param globalFilters
         *        a consumer that will call methods on {@link PatchFilterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalFilters(PatchFilterGroup)
         */
        default Builder globalFilters(Consumer<PatchFilterGroup.Builder> globalFilters) {
            return globalFilters(PatchFilterGroup.builder().applyMutation(globalFilters).build());
        }

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * 
         * @param approvalRules
         *        A set of rules used to include patches in the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRules(PatchRuleGroup approvalRules);

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * This is a convenience that creates an instance of the {@link PatchRuleGroup.Builder} avoiding the need to
         * create one manually via {@link PatchRuleGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchRuleGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #approvalRules(PatchRuleGroup)}.
         * 
         * @param approvalRules
         *        a consumer that will call methods on {@link PatchRuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalRules(PatchRuleGroup)
         */
        default Builder approvalRules(Consumer<PatchRuleGroup.Builder> approvalRules) {
            return approvalRules(PatchRuleGroup.builder().applyMutation(approvalRules).build());
        }

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(Collection<String> approvedPatches);

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(String... approvedPatches);

        /**
         * <p>
         * Defines the compliance level for approved patches. This means that if an approved patch is reported as
         * missing, this is the severity of the compliance violation. Valid compliance severity levels include the
         * following: CRITICAL, HIGH, MEDIUM, LOW, INFORMATIONAL, UNSPECIFIED. The default value is UNSPECIFIED.
         * </p>
         * 
         * @param approvedPatchesComplianceLevel
         *        Defines the compliance level for approved patches. This means that if an approved patch is reported as
         *        missing, this is the severity of the compliance violation. Valid compliance severity levels include
         *        the following: CRITICAL, HIGH, MEDIUM, LOW, INFORMATIONAL, UNSPECIFIED. The default value is
         *        UNSPECIFIED.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel);

        /**
         * <p>
         * Defines the compliance level for approved patches. This means that if an approved patch is reported as
         * missing, this is the severity of the compliance violation. Valid compliance severity levels include the
         * following: CRITICAL, HIGH, MEDIUM, LOW, INFORMATIONAL, UNSPECIFIED. The default value is UNSPECIFIED.
         * </p>
         * 
         * @param approvedPatchesComplianceLevel
         *        Defines the compliance level for approved patches. This means that if an approved patch is reported as
         *        missing, this is the severity of the compliance violation. Valid compliance severity levels include
         *        the following: CRITICAL, HIGH, MEDIUM, LOW, INFORMATIONAL, UNSPECIFIED. The default value is
         *        UNSPECIFIED.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(Collection<String> rejectedPatches);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(String... rejectedPatches);

        /**
         * <p>
         * A description of the patch baseline.
         * </p>
         * 
         * @param description
         *        A description of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * User-provided idempotency token.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String operatingSystem;

        private String name;

        private PatchFilterGroup globalFilters;

        private PatchRuleGroup approvalRules;

        private List<String> approvedPatches = DefaultSdkAutoConstructList.getInstance();

        private String approvedPatchesComplianceLevel;

        private List<String> rejectedPatches = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePatchBaselineRequest model) {
            super(model);
            operatingSystem(model.operatingSystem);
            name(model.name);
            globalFilters(model.globalFilters);
            approvalRules(model.approvalRules);
            approvedPatches(model.approvedPatches);
            approvedPatchesComplianceLevel(model.approvedPatchesComplianceLevel);
            rejectedPatches(model.rejectedPatches);
            description(model.description);
            clientToken(model.clientToken);
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return globalFilters != null ? globalFilters.toBuilder() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return approvalRules != null ? approvalRules.toBuilder() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        public final Collection<String> getApprovedPatches() {
            return approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String... approvedPatches) {
            approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        public final String getApprovedPatchesComplianceLevel() {
            return approvedPatchesComplianceLevel;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel.toString());
            return this;
        }

        public final void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
        }

        public final Collection<String> getRejectedPatches() {
            return rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String... rejectedPatches) {
            rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePatchBaselineRequest build() {
            return new CreatePatchBaselineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
