/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.StepExecution;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StepExecutionMarshaller {
    private static final MarshallingInfo<String> STEPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepName").isBinary(false).build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXECUTIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionStartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXECUTIONENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEndTime").isBinary(false).build();
    private static final MarshallingInfo<String> STEPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepStatus").isBinary(false).build();
    private static final MarshallingInfo<String> RESPONSECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseCode").isBinary(false).build();
    private static final MarshallingInfo<Map> INPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inputs").isBinary(false).build();
    private static final MarshallingInfo<Map> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").isBinary(false).build();
    private static final MarshallingInfo<String> RESPONSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Response").isBinary(false).build();
    private static final MarshallingInfo<String> FAILUREMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureMessage").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FAILUREDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureDetails").isBinary(false).build();
    private static final StepExecutionMarshaller INSTANCE = new StepExecutionMarshaller();

    private StepExecutionMarshaller() {
    }

    public static StepExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepExecution stepExecution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stepExecution, (String)"stepExecution");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stepExecution.stepName(), STEPNAME_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.executionStartTime(), EXECUTIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.executionEndTime(), EXECUTIONENDTIME_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.stepStatusAsString(), STEPSTATUS_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.responseCode(), RESPONSECODE_BINDING);
            protocolMarshaller.marshall(stepExecution.inputs(), INPUTS_BINDING);
            protocolMarshaller.marshall(stepExecution.outputs(), OUTPUTS_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.response(), RESPONSE_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.failureMessage(), FAILUREMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)stepExecution.failureDetails(), FAILUREDETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

