/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutComplianceItemsRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionSummary").isBinary(false).build();
    private static final MarshallingInfo<List> ITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Items").isBinary(false).build();
    private static final MarshallingInfo<String> ITEMCONTENTHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemContentHash").isBinary(false).build();
    private static final PutComplianceItemsRequestModelMarshaller INSTANCE = new PutComplianceItemsRequestModelMarshaller();

    private PutComplianceItemsRequestModelMarshaller() {
    }

    public static PutComplianceItemsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutComplianceItemsRequest putComplianceItemsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putComplianceItemsRequest), (String)"putComplianceItemsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.complianceType(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.executionSummary(), EXECUTIONSUMMARY_BINDING);
            protocolMarshaller.marshall(putComplianceItemsRequest.items(), ITEMS_BINDING);
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.itemContentHash(), ITEMCONTENTHASH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

