/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTargetsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeMaintenanceWindowTargetsRequestMarshaller
implements Marshaller<Request<DescribeMaintenanceWindowTargetsRequest>, DescribeMaintenanceWindowTargetsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AmazonSSM.DescribeMaintenanceWindowTargets").serviceName("Amazon SSM").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DescribeMaintenanceWindowTargetsRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeMaintenanceWindowTargetsRequest> marshall(DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) {
        Validate.paramNotNull((Object)((Object)describeMaintenanceWindowTargetsRequest), (String)"describeMaintenanceWindowTargetsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeMaintenanceWindowTargetsRequest);
            protocolMarshaller.startMarshalling();
            DescribeMaintenanceWindowTargetsRequestModelMarshaller.getInstance().marshall(describeMaintenanceWindowTargetsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

