/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchOperationType;
import software.amazon.awssdk.services.ssm.transform.InstancePatchStateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstancePatchState
implements StructuredPojo,
ToCopyableBuilder<Builder, InstancePatchState> {
    private final String instanceId;
    private final String patchGroup;
    private final String baselineId;
    private final String snapshotId;
    private final String ownerInformation;
    private final Integer installedCount;
    private final Integer installedOtherCount;
    private final Integer missingCount;
    private final Integer failedCount;
    private final Integer notApplicableCount;
    private final Instant operationStartTime;
    private final Instant operationEndTime;
    private final String operation;

    private InstancePatchState(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.patchGroup = builder.patchGroup;
        this.baselineId = builder.baselineId;
        this.snapshotId = builder.snapshotId;
        this.ownerInformation = builder.ownerInformation;
        this.installedCount = builder.installedCount;
        this.installedOtherCount = builder.installedOtherCount;
        this.missingCount = builder.missingCount;
        this.failedCount = builder.failedCount;
        this.notApplicableCount = builder.notApplicableCount;
        this.operationStartTime = builder.operationStartTime;
        this.operationEndTime = builder.operationEndTime;
        this.operation = builder.operation;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String patchGroup() {
        return this.patchGroup;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String ownerInformation() {
        return this.ownerInformation;
    }

    public Integer installedCount() {
        return this.installedCount;
    }

    public Integer installedOtherCount() {
        return this.installedOtherCount;
    }

    public Integer missingCount() {
        return this.missingCount;
    }

    public Integer failedCount() {
        return this.failedCount;
    }

    public Integer notApplicableCount() {
        return this.notApplicableCount;
    }

    public Instant operationStartTime() {
        return this.operationStartTime;
    }

    public Instant operationEndTime() {
        return this.operationEndTime;
    }

    public PatchOperationType operation() {
        return PatchOperationType.fromValue(this.operation);
    }

    public String operationAsString() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedOtherCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.notApplicableCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePatchState)) {
            return false;
        }
        InstancePatchState other = (InstancePatchState)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.patchGroup(), other.patchGroup()) && Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.ownerInformation(), other.ownerInformation()) && Objects.equals(this.installedCount(), other.installedCount()) && Objects.equals(this.installedOtherCount(), other.installedOtherCount()) && Objects.equals(this.missingCount(), other.missingCount()) && Objects.equals(this.failedCount(), other.failedCount()) && Objects.equals(this.notApplicableCount(), other.notApplicableCount()) && Objects.equals(this.operationStartTime(), other.operationStartTime()) && Objects.equals(this.operationEndTime(), other.operationEndTime()) && Objects.equals(this.operationAsString(), other.operationAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstancePatchState").add("InstanceId", (Object)this.instanceId()).add("PatchGroup", (Object)this.patchGroup()).add("BaselineId", (Object)this.baselineId()).add("SnapshotId", (Object)this.snapshotId()).add("OwnerInformation", (Object)this.ownerInformation()).add("InstalledCount", (Object)this.installedCount()).add("InstalledOtherCount", (Object)this.installedOtherCount()).add("MissingCount", (Object)this.missingCount()).add("FailedCount", (Object)this.failedCount()).add("NotApplicableCount", (Object)this.notApplicableCount()).add("OperationStartTime", (Object)this.operationStartTime()).add("OperationEndTime", (Object)this.operationEndTime()).add("Operation", (Object)this.operationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PatchGroup": {
                return Optional.ofNullable(clazz.cast(this.patchGroup()));
            }
            case "BaselineId": {
                return Optional.ofNullable(clazz.cast(this.baselineId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "OwnerInformation": {
                return Optional.ofNullable(clazz.cast(this.ownerInformation()));
            }
            case "InstalledCount": {
                return Optional.ofNullable(clazz.cast(this.installedCount()));
            }
            case "InstalledOtherCount": {
                return Optional.ofNullable(clazz.cast(this.installedOtherCount()));
            }
            case "MissingCount": {
                return Optional.ofNullable(clazz.cast(this.missingCount()));
            }
            case "FailedCount": {
                return Optional.ofNullable(clazz.cast(this.failedCount()));
            }
            case "NotApplicableCount": {
                return Optional.ofNullable(clazz.cast(this.notApplicableCount()));
            }
            case "OperationStartTime": {
                return Optional.ofNullable(clazz.cast(this.operationStartTime()));
            }
            case "OperationEndTime": {
                return Optional.ofNullable(clazz.cast(this.operationEndTime()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePatchStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String patchGroup;
        private String baselineId;
        private String snapshotId;
        private String ownerInformation;
        private Integer installedCount;
        private Integer installedOtherCount;
        private Integer missingCount;
        private Integer failedCount;
        private Integer notApplicableCount;
        private Instant operationStartTime;
        private Instant operationEndTime;
        private String operation;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePatchState model) {
            this.instanceId(model.instanceId);
            this.patchGroup(model.patchGroup);
            this.baselineId(model.baselineId);
            this.snapshotId(model.snapshotId);
            this.ownerInformation(model.ownerInformation);
            this.installedCount(model.installedCount);
            this.installedOtherCount(model.installedOtherCount);
            this.missingCount(model.missingCount);
            this.failedCount(model.failedCount);
            this.notApplicableCount(model.notApplicableCount);
            this.operationStartTime(model.operationStartTime);
            this.operationEndTime(model.operationEndTime);
            this.operation(model.operation);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPatchGroup() {
            return this.patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final Integer getInstalledCount() {
            return this.installedCount;
        }

        @Override
        public final Builder installedCount(Integer installedCount) {
            this.installedCount = installedCount;
            return this;
        }

        public final void setInstalledCount(Integer installedCount) {
            this.installedCount = installedCount;
        }

        public final Integer getInstalledOtherCount() {
            return this.installedOtherCount;
        }

        @Override
        public final Builder installedOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
            return this;
        }

        public final void setInstalledOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
        }

        public final Integer getMissingCount() {
            return this.missingCount;
        }

        @Override
        public final Builder missingCount(Integer missingCount) {
            this.missingCount = missingCount;
            return this;
        }

        public final void setMissingCount(Integer missingCount) {
            this.missingCount = missingCount;
        }

        public final Integer getFailedCount() {
            return this.failedCount;
        }

        @Override
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        public final Integer getNotApplicableCount() {
            return this.notApplicableCount;
        }

        @Override
        public final Builder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            return this;
        }

        public final void setNotApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
        }

        public final Instant getOperationStartTime() {
            return this.operationStartTime;
        }

        @Override
        public final Builder operationStartTime(Instant operationStartTime) {
            this.operationStartTime = operationStartTime;
            return this;
        }

        public final void setOperationStartTime(Instant operationStartTime) {
            this.operationStartTime = operationStartTime;
        }

        public final Instant getOperationEndTime() {
            return this.operationEndTime;
        }

        @Override
        public final Builder operationEndTime(Instant operationEndTime) {
            this.operationEndTime = operationEndTime;
            return this;
        }

        public final void setOperationEndTime(Instant operationEndTime) {
            this.operationEndTime = operationEndTime;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(PatchOperationType operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public InstancePatchState build() {
            return new InstancePatchState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstancePatchState> {
        public Builder instanceId(String var1);

        public Builder patchGroup(String var1);

        public Builder baselineId(String var1);

        public Builder snapshotId(String var1);

        public Builder ownerInformation(String var1);

        public Builder installedCount(Integer var1);

        public Builder installedOtherCount(Integer var1);

        public Builder missingCount(Integer var1);

        public Builder failedCount(Integer var1);

        public Builder notApplicableCount(Integer var1);

        public Builder operationStartTime(Instant var1);

        public Builder operationEndTime(Instant var1);

        public Builder operation(String var1);

        public Builder operation(PatchOperationType var1);
    }
}

