/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.S3OutputUrlMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A URL for the Amazon S3 bucket where you want to store the results of this request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3OutputUrl implements StructuredPojo, ToCopyableBuilder<S3OutputUrl.Builder, S3OutputUrl> {
    private final String outputUrl;

    private S3OutputUrl(BuilderImpl builder) {
        this.outputUrl = builder.outputUrl;
    }

    /**
     * <p>
     * A URL for an Amazon S3 bucket where you want to store the results of this request.
     * </p>
     * 
     * @return A URL for an Amazon S3 bucket where you want to store the results of this request.
     */
    public String outputUrl() {
        return outputUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputUrl)) {
            return false;
        }
        S3OutputUrl other = (S3OutputUrl) obj;
        return Objects.equals(outputUrl(), other.outputUrl());
    }

    @Override
    public String toString() {
        return ToString.builder("S3OutputUrl").add("OutputUrl", outputUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputUrl":
            return Optional.ofNullable(clazz.cast(outputUrl()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3OutputUrlMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3OutputUrl> {
        /**
         * <p>
         * A URL for an Amazon S3 bucket where you want to store the results of this request.
         * </p>
         * 
         * @param outputUrl
         *        A URL for an Amazon S3 bucket where you want to store the results of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUrl(String outputUrl);
    }

    static final class BuilderImpl implements Builder {
        private String outputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputUrl model) {
            outputUrl(model.outputUrl);
        }

        public final String getOutputUrl() {
            return outputUrl;
        }

        @Override
        public final Builder outputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final void setOutputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
        }

        @Override
        public S3OutputUrl build() {
            return new S3OutputUrl(this);
        }
    }
}
