/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A sync configuration with the same name already exists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDataSyncAlreadyExistsException extends SsmException implements
        ToCopyableBuilder<ResourceDataSyncAlreadyExistsException.Builder, ResourceDataSyncAlreadyExistsException> {
    private final String syncName;

    private ResourceDataSyncAlreadyExistsException(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the SyncName property for this object.
     * 
     * @return The value of the SyncName property for this object.
     */
    public String syncName() {
        return syncName;
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceDataSyncAlreadyExistsException>, SsmException.Builder {
        /**
         * Sets the value of the SyncName property for this object.
         *
         * @param syncName
         *        The new value for the SyncName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncName(String syncName);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends SsmException.BuilderImpl implements Builder {
        private String syncName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncAlreadyExistsException model) {
            super(model);
            syncName(model.syncName);
        }

        public final String getSyncName() {
            return syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        @JsonProperty("SyncName")
        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ResourceDataSyncAlreadyExistsException build() {
            return new ResourceDataSyncAlreadyExistsException(this);
        }
    }
}
