/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterTaskWithMaintenanceWindowResponse extends SsmResponse implements
        ToCopyableBuilder<RegisterTaskWithMaintenanceWindowResponse.Builder, RegisterTaskWithMaintenanceWindowResponse> {
    private final String windowTaskId;

    private RegisterTaskWithMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowTaskId = builder.windowTaskId;
    }

    /**
     * <p>
     * The id of the task in the Maintenance Window.
     * </p>
     * 
     * @return The id of the task in the Maintenance Window.
     */
    public String windowTaskId() {
        return windowTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowTaskId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskWithMaintenanceWindowResponse)) {
            return false;
        }
        RegisterTaskWithMaintenanceWindowResponse other = (RegisterTaskWithMaintenanceWindowResponse) obj;
        return Objects.equals(windowTaskId(), other.windowTaskId());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterTaskWithMaintenanceWindowResponse").add("WindowTaskId", windowTaskId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowTaskId":
            return Optional.ofNullable(clazz.cast(windowTaskId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmResponse.Builder, CopyableBuilder<Builder, RegisterTaskWithMaintenanceWindowResponse> {
        /**
         * <p>
         * The id of the task in the Maintenance Window.
         * </p>
         * 
         * @param windowTaskId
         *        The id of the task in the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTaskId(String windowTaskId);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String windowTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTaskWithMaintenanceWindowResponse model) {
            super(model);
            windowTaskId(model.windowTaskId);
        }

        public final String getWindowTaskId() {
            return windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        @Override
        public RegisterTaskWithMaintenanceWindowResponse build() {
            return new RegisterTaskWithMaintenanceWindowResponse(this);
        }
    }
}
