/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowTaskParameterValueExpressionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the values for a task parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindowTaskParameterValueExpression implements StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowTaskParameterValueExpression.Builder, MaintenanceWindowTaskParameterValueExpression> {
    private final List<String> values;

    private MaintenanceWindowTaskParameterValueExpression(BuilderImpl builder) {
        this.values = builder.values;
    }

    /**
     * <p>
     * This field contains an array of 0 or more strings, each 1 to 255 characters in length.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This field contains an array of 0 or more strings, each 1 to 255 characters in length.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTaskParameterValueExpression)) {
            return false;
        }
        MaintenanceWindowTaskParameterValueExpression other = (MaintenanceWindowTaskParameterValueExpression) obj;
        return Objects.equals(values(), other.values());
    }

    @Override
    public String toString() {
        return ToString.builder("MaintenanceWindowTaskParameterValueExpression").add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTaskParameterValueExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowTaskParameterValueExpression> {
        /**
         * <p>
         * This field contains an array of 0 or more strings, each 1 to 255 characters in length.
         * </p>
         * 
         * @param values
         *        This field contains an array of 0 or more strings, each 1 to 255 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * This field contains an array of 0 or more strings, each 1 to 255 characters in length.
         * </p>
         * 
         * @param values
         *        This field contains an array of 0 or more strings, each 1 to 255 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTaskParameterValueExpression model) {
            values(model.values);
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = MaintenanceWindowTaskParameterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = MaintenanceWindowTaskParameterValueListCopier.copy(values);
        }

        @Override
        public MaintenanceWindowTaskParameterValueExpression build() {
            return new MaintenanceWindowTaskParameterValueExpression(this);
        }
    }
}
