/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.DocumentVersionInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Version information about the document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentVersionInfo implements StructuredPojo,
        ToCopyableBuilder<DocumentVersionInfo.Builder, DocumentVersionInfo> {
    private final String name;

    private final String documentVersion;

    private final Instant createdDate;

    private final Boolean isDefaultVersion;

    private DocumentVersionInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.createdDate = builder.createdDate;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    /**
     * <p>
     * The document name.
     * </p>
     * 
     * @return The document name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The document version.
     * </p>
     * 
     * @return The document version.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The date the document was created.
     * </p>
     * 
     * @return The date the document was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * An identifier for the default version of the document.
     * </p>
     * 
     * @return An identifier for the default version of the document.
     */
    public Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentVersionInfo)) {
            return false;
        }
        DocumentVersionInfo other = (DocumentVersionInfo) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(isDefaultVersion(), other.isDefaultVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("DocumentVersionInfo").add("Name", name()).add("DocumentVersion", documentVersion())
                .add("CreatedDate", createdDate()).add("IsDefaultVersion", isDefaultVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "IsDefaultVersion":
            return Optional.ofNullable(clazz.cast(isDefaultVersion()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentVersionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DocumentVersionInfo> {
        /**
         * <p>
         * The document name.
         * </p>
         * 
         * @param name
         *        The document name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The document version.
         * </p>
         * 
         * @param documentVersion
         *        The document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The date the document was created.
         * </p>
         * 
         * @param createdDate
         *        The date the document was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * An identifier for the default version of the document.
         * </p>
         * 
         * @param isDefaultVersion
         *        An identifier for the default version of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String documentVersion;

        private Instant createdDate;

        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentVersionInfo model) {
            name(model.name);
            documentVersion(model.documentVersion);
            createdDate(model.createdDate);
            isDefaultVersion(model.isDefaultVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public DocumentVersionInfo build() {
            return new DocumentVersionInfo(this);
        }
    }
}
