/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancePatchesRequest extends SsmRequest implements
        ToCopyableBuilder<DescribeInstancePatchesRequest.Builder, DescribeInstancePatchesRequest> {
    private final String instanceId;

    private final List<PatchOrchestratorFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeInstancePatchesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the instance whose patch state information should be retrieved.
     * </p>
     * 
     * @return The ID of the instance whose patch state information should be retrieved.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Each entry in the array is a structure containing:
     * </p>
     * <p>
     * Key (string, between 1 and 128 characters)
     * </p>
     * <p>
     * Values (array of strings, each string between 1 and 256 characters)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Each entry in the array is a structure containing:</p>
     *         <p>
     *         Key (string, between 1 and 128 characters)
     *         </p>
     *         <p>
     *         Values (array of strings, each string between 1 and 256 characters)
     */
    public List<PatchOrchestratorFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of patches to return (per page).
     * </p>
     * 
     * @return The maximum number of patches to return (per page).
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchesRequest)) {
            return false;
        }
        DescribeInstancePatchesRequest other = (DescribeInstancePatchesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeInstancePatchesRequest").add("InstanceId", instanceId()).add("Filters", filters())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmRequest.Builder, CopyableBuilder<Builder, DescribeInstancePatchesRequest> {
        /**
         * <p>
         * The ID of the instance whose patch state information should be retrieved.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance whose patch state information should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string, between 1 and 128 characters)
         * </p>
         * <p>
         * Values (array of strings, each string between 1 and 256 characters)
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string, between 1 and 128 characters)
         *        </p>
         *        <p>
         *        Values (array of strings, each string between 1 and 256 characters)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<PatchOrchestratorFilter> filters);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string, between 1 and 128 characters)
         * </p>
         * <p>
         * Values (array of strings, each string between 1 and 256 characters)
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string, between 1 and 128 characters)
         *        </p>
         *        <p>
         *        Values (array of strings, each string between 1 and 256 characters)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(PatchOrchestratorFilter... filters);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string, between 1 and 128 characters)
         * </p>
         * <p>
         * Values (array of strings, each string between 1 and 256 characters)
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchOrchestratorFilter>.Builder} avoiding
         * the need to create one manually via {@link List<PatchOrchestratorFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchOrchestratorFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<PatchOrchestratorFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<PatchOrchestratorFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<PatchOrchestratorFilter>)
         */
        Builder filters(Consumer<PatchOrchestratorFilter.Builder>... filters);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of patches to return (per page).
         * </p>
         * 
         * @param maxResults
         *        The maximum number of patches to return (per page).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<PatchOrchestratorFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchesRequest model) {
            super(model);
            instanceId(model.instanceId);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<PatchOrchestratorFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(PatchOrchestratorFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<PatchOrchestratorFilter> filters) {
            this.filters = PatchOrchestratorFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(PatchOrchestratorFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<PatchOrchestratorFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> PatchOrchestratorFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<PatchOrchestratorFilter.BuilderImpl> filters) {
            this.filters = PatchOrchestratorFilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancePatchesRequest build() {
            return new DescribeInstancePatchesRequest(this);
        }
    }
}
