/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDocumentPermissionResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeDocumentPermissionResponse.Builder, DescribeDocumentPermissionResponse> {
    private final List<String> accountIds;

    private DescribeDocumentPermissionResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
    }

    /**
     * <p>
     * The account IDs that have permission to use this document. The ID can be either an AWS account or <i>All</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The account IDs that have permission to use this document. The ID can be either an AWS account or
     *         <i>All</i>.
     */
    public List<String> accountIds() {
        return accountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentPermissionResponse)) {
            return false;
        }
        DescribeDocumentPermissionResponse other = (DescribeDocumentPermissionResponse) obj;
        return Objects.equals(accountIds(), other.accountIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDocumentPermissionResponse").add("AccountIds", accountIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmResponse.Builder, CopyableBuilder<Builder, DescribeDocumentPermissionResponse> {
        /**
         * <p>
         * The account IDs that have permission to use this document. The ID can be either an AWS account or <i>All</i>.
         * </p>
         * 
         * @param accountIds
         *        The account IDs that have permission to use this document. The ID can be either an AWS account or
         *        <i>All</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The account IDs that have permission to use this document. The ID can be either an AWS account or <i>All</i>.
         * </p>
         * 
         * @param accountIds
         *        The account IDs that have permission to use this document. The ID can be either an AWS account or
         *        <i>All</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentPermissionResponse model) {
            super(model);
            accountIds(model.accountIds);
        }

        public final Collection<String> getAccountIds() {
            return accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public DescribeDocumentPermissionResponse build() {
            return new DescribeDocumentPermissionResponse(this);
        }
    }
}
