/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeMaintenanceWindowTargetsRequestModelMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").isBinary(false).build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final DescribeMaintenanceWindowTargetsRequestModelMarshaller INSTANCE = new DescribeMaintenanceWindowTargetsRequestModelMarshaller();

    private DescribeMaintenanceWindowTargetsRequestModelMarshaller() {
    }

    public static DescribeMaintenanceWindowTargetsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeMaintenanceWindowTargetsRequest), (String)"describeMaintenanceWindowTargetsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeMaintenanceWindowTargetsRequest.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall(describeMaintenanceWindowTargetsRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)describeMaintenanceWindowTargetsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)describeMaintenanceWindowTargetsRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

