/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AutomationExecutionFilterMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").isBinary(false).build();
    private static final AutomationExecutionFilterMarshaller INSTANCE = new AutomationExecutionFilterMarshaller();

    private AutomationExecutionFilterMarshaller() {
    }

    public static AutomationExecutionFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutomationExecutionFilter automationExecutionFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)automationExecutionFilter, (String)"automationExecutionFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)automationExecutionFilter.keyAsString(), KEY_BINDING);
            protocolMarshaller.marshall(automationExecutionFilter.values(), VALUES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

