/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.AssociationFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AssociationFilterMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final AssociationFilterMarshaller INSTANCE = new AssociationFilterMarshaller();

    private AssociationFilterMarshaller() {
    }

    public static AssociationFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociationFilter associationFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)associationFilter, (String)"associationFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)associationFilter.keyAsString(), KEY_BINDING);
            protocolMarshaller.marshall((Object)associationFilter.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

