/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.FailureDetails;
import software.amazon.awssdk.services.ssm.model.NormalStringMapCopier;
import software.amazon.awssdk.services.ssm.transform.StepExecutionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, StepExecution> {
    private final String stepName;
    private final String action;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String stepStatus;
    private final String responseCode;
    private final Map<String, String> inputs;
    private final Map<String, List<String>> outputs;
    private final String response;
    private final String failureMessage;
    private final FailureDetails failureDetails;

    private StepExecution(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.action = builder.action;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.stepStatus = builder.stepStatus;
        this.responseCode = builder.responseCode;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.response = builder.response;
        this.failureMessage = builder.failureMessage;
        this.failureDetails = builder.failureDetails;
    }

    public String stepName() {
        return this.stepName;
    }

    public String action() {
        return this.action;
    }

    public Instant executionStartTime() {
        return this.executionStartTime;
    }

    public Instant executionEndTime() {
        return this.executionEndTime;
    }

    public AutomationExecutionStatus stepStatus() {
        return AutomationExecutionStatus.fromValue(this.stepStatus);
    }

    public String stepStatusAsString() {
        return this.stepStatus;
    }

    public String responseCode() {
        return this.responseCode;
    }

    public Map<String, String> inputs() {
        return this.inputs;
    }

    public Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public String response() {
        return this.response;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public FailureDetails failureDetails() {
        return this.failureDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.response());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepExecution)) {
            return false;
        }
        StepExecution other = (StepExecution)obj;
        return Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.executionStartTime(), other.executionStartTime()) && Objects.equals(this.executionEndTime(), other.executionEndTime()) && Objects.equals(this.stepStatusAsString(), other.stepStatusAsString()) && Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.response(), other.response()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.failureDetails(), other.failureDetails());
    }

    public String toString() {
        return ToString.builder((String)"StepExecution").add("StepName", (Object)this.stepName()).add("Action", (Object)this.action()).add("ExecutionStartTime", (Object)this.executionStartTime()).add("ExecutionEndTime", (Object)this.executionEndTime()).add("StepStatus", (Object)this.stepStatusAsString()).add("ResponseCode", (Object)this.responseCode()).add("Inputs", this.inputs()).add("Outputs", this.outputs()).add("Response", (Object)this.response()).add("FailureMessage", (Object)this.failureMessage()).add("FailureDetails", (Object)this.failureDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "ExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartTime()));
            }
            case "ExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndTime()));
            }
            case "StepStatus": {
                return Optional.ofNullable(clazz.cast(this.stepStatusAsString()));
            }
            case "ResponseCode": {
                return Optional.ofNullable(clazz.cast(this.responseCode()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "Response": {
                return Optional.ofNullable(clazz.cast(this.response()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepName;
        private String action;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private String stepStatus;
        private String responseCode;
        private Map<String, String> inputs = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();
        private String response;
        private String failureMessage;
        private FailureDetails failureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StepExecution model) {
            this.stepName(model.stepName);
            this.action(model.action);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.stepStatus(model.stepStatus);
            this.responseCode(model.responseCode);
            this.inputs(model.inputs);
            this.outputs(model.outputs);
            this.response(model.response);
            this.failureMessage(model.failureMessage);
            this.failureDetails(model.failureDetails);
        }

        public final String getStepName() {
            return this.stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public final String getStepStatus() {
            return this.stepStatus;
        }

        @Override
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        @Override
        public final Builder stepStatus(AutomationExecutionStatus stepStatus) {
            this.stepStatus(stepStatus.toString());
            return this;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        public final String getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        public final Map<String, String> getInputs() {
            return this.inputs;
        }

        @Override
        public final Builder inputs(Map<String, String> inputs) {
            this.inputs = NormalStringMapCopier.copy(inputs);
            return this;
        }

        public final void setInputs(Map<String, String> inputs) {
            this.inputs = NormalStringMapCopier.copy(inputs);
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getResponse() {
            return this.response;
        }

        @Override
        public final Builder response(String response) {
            this.response = response;
            return this;
        }

        public final void setResponse(String response) {
            this.response = response;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        public StepExecution build() {
            return new StepExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepExecution> {
        public Builder stepName(String var1);

        public Builder action(String var1);

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder stepStatus(String var1);

        public Builder stepStatus(AutomationExecutionStatus var1);

        public Builder responseCode(String var1);

        public Builder inputs(Map<String, String> var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder response(String var1);

        public Builder failureMessage(String var1);

        public Builder failureDetails(FailureDetails var1);

        default public Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return this.failureDetails((FailureDetails)((FailureDetails.Builder)FailureDetails.builder().applyMutation(failureDetails)).build());
        }
    }
}

