/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InstanceAssociation;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEffectiveInstanceAssociationsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeEffectiveInstanceAssociationsResponse> {
    private final List<InstanceAssociation> associations;
    private final String nextToken;

    private DescribeEffectiveInstanceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceAssociation> associations() {
        return this.associations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEffectiveInstanceAssociationsResponse)) {
            return false;
        }
        DescribeEffectiveInstanceAssociationsResponse other = (DescribeEffectiveInstanceAssociationsResponse)((Object)obj);
        return Objects.equals(this.associations(), other.associations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEffectiveInstanceAssociationsResponse").add("Associations", this.associations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<InstanceAssociation> associations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEffectiveInstanceAssociationsResponse model) {
            super(model);
            this.associations(model.associations);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceAssociation.Builder> getAssociations() {
            return this.associations != null ? (Collection)this.associations.stream().map(InstanceAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associations(Collection<InstanceAssociation> associations) {
            this.associations = InstanceAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(InstanceAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<InstanceAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (InstanceAssociation)((InstanceAssociation.Builder)InstanceAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociations(Collection<InstanceAssociation.BuilderImpl> associations) {
            this.associations = InstanceAssociationListCopier.copyFromBuilder(associations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEffectiveInstanceAssociationsResponse build() {
            return new DescribeEffectiveInstanceAssociationsResponse(this);
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    CopyableBuilder<Builder, DescribeEffectiveInstanceAssociationsResponse> {
        public Builder associations(Collection<InstanceAssociation> var1);

        public Builder associations(InstanceAssociation ... var1);

        public Builder associations(Consumer<InstanceAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

