/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.S3OutputUrl;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link S3OutputUrl} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class S3OutputUrlMarshaller {
    private static final MarshallingInfo<String> OUTPUTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUrl").isBinary(false).build();

    private static final S3OutputUrlMarshaller INSTANCE = new S3OutputUrlMarshaller();

    private S3OutputUrlMarshaller() {
    }

    public static S3OutputUrlMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(S3OutputUrl s3OutputUrl, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(s3OutputUrl, "s3OutputUrl");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(s3OutputUrl.outputUrl(), OUTPUTURL_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
