/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * MaintenanceWindowRunCommandParameters JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MaintenanceWindowRunCommandParametersUnmarshaller implements
        Unmarshaller<MaintenanceWindowRunCommandParameters, JsonUnmarshallerContext> {

    public MaintenanceWindowRunCommandParameters unmarshall(JsonUnmarshallerContext context) throws Exception {
        MaintenanceWindowRunCommandParameters.Builder maintenanceWindowRunCommandParametersBuilder = MaintenanceWindowRunCommandParameters
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Comment", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowRunCommandParametersBuilder.comment(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("DocumentHash", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowRunCommandParametersBuilder.documentHash(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("DocumentHashType", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowRunCommandParametersBuilder.documentHashType(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("NotificationConfig", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowRunCommandParametersBuilder.notificationConfig(NotificationConfigUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("OutputS3BucketName", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowRunCommandParametersBuilder.outputS3BucketName(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("OutputS3KeyPrefix", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowRunCommandParametersBuilder.outputS3KeyPrefix(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowRunCommandParametersBuilder.parameters(new MapUnmarshaller<String, java.util.List<String>>(
                            context.getUnmarshaller(String.class), new ListUnmarshaller<String>(context
                                    .getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("ServiceRoleArn", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowRunCommandParametersBuilder.serviceRoleArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("TimeoutSeconds", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowRunCommandParametersBuilder.timeoutSeconds(context.getUnmarshaller(Integer.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return maintenanceWindowRunCommandParametersBuilder.build();
    }

    private static final MaintenanceWindowRunCommandParametersUnmarshaller INSTANCE = new MaintenanceWindowRunCommandParametersUnmarshaller();

    public static MaintenanceWindowRunCommandParametersUnmarshaller getInstance() {
        return INSTANCE;
    }
}
