/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MaintenanceWindowRunCommandParameters} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MaintenanceWindowRunCommandParametersMarshaller {
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTHASH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentHash").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTHASHTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentHashType").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NotificationConfig").isBinary(false).build();

    private static final MarshallingInfo<String> OUTPUTS3BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3BucketName").isBinary(false).build();

    private static final MarshallingInfo<String> OUTPUTS3KEYPREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3KeyPrefix").isBinary(false).build();

    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();

    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").isBinary(false).build();

    private static final MarshallingInfo<Integer> TIMEOUTSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeoutSeconds").isBinary(false).build();

    private static final MaintenanceWindowRunCommandParametersMarshaller INSTANCE = new MaintenanceWindowRunCommandParametersMarshaller();

    private MaintenanceWindowRunCommandParametersMarshaller() {
    }

    public static MaintenanceWindowRunCommandParametersMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MaintenanceWindowRunCommandParameters maintenanceWindowRunCommandParameters,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(maintenanceWindowRunCommandParameters, "maintenanceWindowRunCommandParameters");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(maintenanceWindowRunCommandParameters.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall(maintenanceWindowRunCommandParameters.documentHash(), DOCUMENTHASH_BINDING);
            protocolMarshaller.marshall(maintenanceWindowRunCommandParameters.documentHashTypeAsString(),
                    DOCUMENTHASHTYPE_BINDING);
            protocolMarshaller.marshall(maintenanceWindowRunCommandParameters.notificationConfig(), NOTIFICATIONCONFIG_BINDING);
            protocolMarshaller.marshall(maintenanceWindowRunCommandParameters.outputS3BucketName(), OUTPUTS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall(maintenanceWindowRunCommandParameters.outputS3KeyPrefix(), OUTPUTS3KEYPREFIX_BINDING);
            protocolMarshaller.marshall(maintenanceWindowRunCommandParameters.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(maintenanceWindowRunCommandParameters.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall(maintenanceWindowRunCommandParameters.timeoutSeconds(), TIMEOUTSECONDS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
