/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InstanceAssociationStatusInfo} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InstanceAssociationStatusInfoMarshaller {
    private static final MarshallingInfo<String> ASSOCIATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationId").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();

    private static final MarshallingInfo<String> ASSOCIATIONVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationVersion").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();

    private static final MarshallingInfo<Instant> EXECUTIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionDate").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> DETAILEDSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetailedStatus").isBinary(false).build();

    private static final MarshallingInfo<String> EXECUTIONSUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionSummary").isBinary(false).build();

    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> OUTPUTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUrl").isBinary(false).build();

    private static final MarshallingInfo<String> ASSOCIATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationName").isBinary(false).build();

    private static final InstanceAssociationStatusInfoMarshaller INSTANCE = new InstanceAssociationStatusInfoMarshaller();

    private InstanceAssociationStatusInfoMarshaller() {
    }

    public static InstanceAssociationStatusInfoMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InstanceAssociationStatusInfo instanceAssociationStatusInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(instanceAssociationStatusInfo, "instanceAssociationStatusInfo");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(instanceAssociationStatusInfo.associationId(), ASSOCIATIONID_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.name(), NAME_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.associationVersion(), ASSOCIATIONVERSION_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.executionDate(), EXECUTIONDATE_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.status(), STATUS_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.detailedStatus(), DETAILEDSTATUS_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.executionSummary(), EXECUTIONSUMMARY_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.outputUrl(), OUTPUTURL_BINDING);
            protocolMarshaller.marshall(instanceAssociationStatusInfo.associationName(), ASSOCIATIONNAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
