/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ComplianceItem;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ComplianceItem} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ComplianceItemMarshaller {
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").isBinary(false).build();

    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();

    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> SEVERITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Severity").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> EXECUTIONSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ExecutionSummary").isBinary(false).build();

    private static final MarshallingInfo<Map> DETAILS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Details").isBinary(false).build();

    private static final ComplianceItemMarshaller INSTANCE = new ComplianceItemMarshaller();

    private ComplianceItemMarshaller() {
    }

    public static ComplianceItemMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ComplianceItem complianceItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(complianceItem, "complianceItem");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(complianceItem.complianceType(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall(complianceItem.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(complianceItem.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(complianceItem.id(), ID_BINDING);
            protocolMarshaller.marshall(complianceItem.title(), TITLE_BINDING);
            protocolMarshaller.marshall(complianceItem.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(complianceItem.severityAsString(), SEVERITY_BINDING);
            protocolMarshaller.marshall(complianceItem.executionSummary(), EXECUTIONSUMMARY_BINDING);
            protocolMarshaller.marshall(complianceItem.details(), DETAILS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
