/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Activation} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ActivationMarshaller {
    private static final MarshallingInfo<String> ACTIVATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivationId").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<String> DEFAULTINSTANCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultInstanceName").isBinary(false).build();

    private static final MarshallingInfo<String> IAMROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRole").isBinary(false).build();

    private static final MarshallingInfo<Integer> REGISTRATIONLIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationLimit").isBinary(false).build();

    private static final MarshallingInfo<Integer> REGISTRATIONSCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationsCount").isBinary(false).build();

    private static final MarshallingInfo<Instant> EXPIRATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationDate").isBinary(false).build();

    private static final MarshallingInfo<Boolean> EXPIRED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expired").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").isBinary(false).build();

    private static final ActivationMarshaller INSTANCE = new ActivationMarshaller();

    private ActivationMarshaller() {
    }

    public static ActivationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Activation activation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(activation, "activation");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(activation.activationId(), ACTIVATIONID_BINDING);
            protocolMarshaller.marshall(activation.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(activation.defaultInstanceName(), DEFAULTINSTANCENAME_BINDING);
            protocolMarshaller.marshall(activation.iamRole(), IAMROLE_BINDING);
            protocolMarshaller.marshall(activation.registrationLimit(), REGISTRATIONLIMIT_BINDING);
            protocolMarshaller.marshall(activation.registrationsCount(), REGISTRATIONSCOUNT_BINDING);
            protocolMarshaller.marshall(activation.expirationDate(), EXPIRATIONDATE_BINDING);
            protocolMarshaller.marshall(activation.expired(), EXPIRED_BINDING);
            protocolMarshaller.marshall(activation.createdDate(), CREATEDDATE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
