/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAutomationExecutionResponse extends SsmResponse implements
        ToCopyableBuilder<StartAutomationExecutionResponse.Builder, StartAutomationExecutionResponse> {
    private final String automationExecutionId;

    private StartAutomationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.automationExecutionId = builder.automationExecutionId;
    }

    /**
     * <p>
     * The unique ID of a newly scheduled automation execution.
     * </p>
     * 
     * @return The unique ID of a newly scheduled automation execution.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomationExecutionResponse)) {
            return false;
        }
        StartAutomationExecutionResponse other = (StartAutomationExecutionResponse) obj;
        return Objects.equals(automationExecutionId(), other.automationExecutionId());
    }

    @Override
    public String toString() {
        return ToString.builder("StartAutomationExecutionResponse").add("AutomationExecutionId", automationExecutionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionId":
            return Optional.ofNullable(clazz.cast(automationExecutionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmResponse.Builder, CopyableBuilder<Builder, StartAutomationExecutionResponse> {
        /**
         * <p>
         * The unique ID of a newly scheduled automation execution.
         * </p>
         * 
         * @param automationExecutionId
         *        The unique ID of a newly scheduled automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String automationExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomationExecutionResponse model) {
            super(model);
            automationExecutionId(model.automationExecutionId);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        @Override
        public StartAutomationExecutionResponse build() {
            return new StartAutomationExecutionResponse(this);
        }
    }
}
