/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsResponse;

@Generated("software.amazon.awssdk:codegen")
public abstract class SsmResponse extends AwsResponse {
    protected SsmResponse(Builder builder) {
        super(builder);
    }

    public interface Builder extends AwsResponse.Builder {
        @Override
        SsmResponse build();
    }

    protected abstract static class BuilderImpl extends AwsResponse.BuilderImpl implements Builder {
        protected BuilderImpl() {
        }

        protected BuilderImpl(SsmResponse response) {
            super(response);
        }
    }
}
