/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInventorySchemaRequest extends SsmRequest implements
        ToCopyableBuilder<GetInventorySchemaRequest.Builder, GetInventorySchemaRequest> {
    private final String typeName;

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean aggregator;

    private final Boolean subType;

    private GetInventorySchemaRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.aggregator = builder.aggregator;
        this.subType = builder.subType;
    }

    /**
     * <p>
     * The type of inventory item to return.
     * </p>
     * 
     * @return The type of inventory item to return.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Returns inventory schemas that support aggregation. For example, this call returns the
     * <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.
     * </p>
     * 
     * @return Returns inventory schemas that support aggregation. For example, this call returns the
     *         <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
     *         <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.
     */
    public Boolean aggregator() {
        return aggregator;
    }

    /**
     * <p>
     * Returns the sub-type schema for a specified inventory type.
     * </p>
     * 
     * @return Returns the sub-type schema for a specified inventory type.
     */
    public Boolean subType() {
        return subType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(aggregator());
        hashCode = 31 * hashCode + Objects.hashCode(subType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventorySchemaRequest)) {
            return false;
        }
        GetInventorySchemaRequest other = (GetInventorySchemaRequest) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(aggregator(), other.aggregator())
                && Objects.equals(subType(), other.subType());
    }

    @Override
    public String toString() {
        return ToString.builder("GetInventorySchemaRequest").add("TypeName", typeName()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Aggregator", aggregator()).add("SubType", subType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Aggregator":
            return Optional.ofNullable(clazz.cast(aggregator()));
        case "SubType":
            return Optional.ofNullable(clazz.cast(subType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmRequest.Builder, CopyableBuilder<Builder, GetInventorySchemaRequest> {
        /**
         * <p>
         * The type of inventory item to return.
         * </p>
         * 
         * @param typeName
         *        The type of inventory item to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Returns inventory schemas that support aggregation. For example, this call returns the
         * <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
         * <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.
         * </p>
         * 
         * @param aggregator
         *        Returns inventory schemas that support aggregation. For example, this call returns the
         *        <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
         *        <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregator(Boolean aggregator);

        /**
         * <p>
         * Returns the sub-type schema for a specified inventory type.
         * </p>
         * 
         * @param subType
         *        Returns the sub-type schema for a specified inventory type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subType(Boolean subType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String typeName;

        private String nextToken;

        private Integer maxResults;

        private Boolean aggregator;

        private Boolean subType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventorySchemaRequest model) {
            super(model);
            typeName(model.typeName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            aggregator(model.aggregator);
            subType(model.subType);
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Boolean getAggregator() {
            return aggregator;
        }

        @Override
        public final Builder aggregator(Boolean aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public final void setAggregator(Boolean aggregator) {
            this.aggregator = aggregator;
        }

        public final Boolean getSubType() {
            return subType;
        }

        @Override
        public final Builder subType(Boolean subType) {
            this.subType = subType;
            return this;
        }

        public final void setSubType(Boolean subType) {
            this.subType = subType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInventorySchemaRequest build() {
            return new GetInventorySchemaRequest(this);
        }
    }
}
