/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMaintenanceWindowExecutionsResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeMaintenanceWindowExecutionsResponse.Builder, DescribeMaintenanceWindowExecutionsResponse> {
    private final List<MaintenanceWindowExecution> windowExecutions;

    private final String nextToken;

    private DescribeMaintenanceWindowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutions = builder.windowExecutions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the Maintenance Windows execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Maintenance Windows execution.
     */
    public List<MaintenanceWindowExecution> windowExecutions() {
        return windowExecutions;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionsResponse other = (DescribeMaintenanceWindowExecutionsResponse) obj;
        return Objects.equals(windowExecutions(), other.windowExecutions()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMaintenanceWindowExecutionsResponse").add("WindowExecutions", windowExecutions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutions":
            return Optional.ofNullable(clazz.cast(windowExecutions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmResponse.Builder, CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionsResponse> {
        /**
         * <p>
         * Information about the Maintenance Windows execution.
         * </p>
         * 
         * @param windowExecutions
         *        Information about the Maintenance Windows execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutions(Collection<MaintenanceWindowExecution> windowExecutions);

        /**
         * <p>
         * Information about the Maintenance Windows execution.
         * </p>
         * 
         * @param windowExecutions
         *        Information about the Maintenance Windows execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutions(MaintenanceWindowExecution... windowExecutions);

        /**
         * <p>
         * Information about the Maintenance Windows execution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MaintenanceWindowExecution>.Builder}
         * avoiding the need to create one manually via {@link List<MaintenanceWindowExecution>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MaintenanceWindowExecution>.Builder#build()} is called
         * immediately and its result is passed to {@link #windowExecutions(List<MaintenanceWindowExecution>)}.
         * 
         * @param windowExecutions
         *        a consumer that will call methods on {@link List<MaintenanceWindowExecution>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowExecutions(List<MaintenanceWindowExecution>)
         */
        Builder windowExecutions(Consumer<MaintenanceWindowExecution.Builder>... windowExecutions);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<MaintenanceWindowExecution> windowExecutions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionsResponse model) {
            super(model);
            windowExecutions(model.windowExecutions);
            nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecution.Builder> getWindowExecutions() {
            return windowExecutions != null ? windowExecutions.stream().map(MaintenanceWindowExecution::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowExecutions(Collection<MaintenanceWindowExecution> windowExecutions) {
            this.windowExecutions = MaintenanceWindowExecutionListCopier.copy(windowExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutions(MaintenanceWindowExecution... windowExecutions) {
            windowExecutions(Arrays.asList(windowExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutions(Consumer<MaintenanceWindowExecution.Builder>... windowExecutions) {
            windowExecutions(Stream.of(windowExecutions).map(c -> MaintenanceWindowExecution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWindowExecutions(Collection<MaintenanceWindowExecution.BuilderImpl> windowExecutions) {
            this.windowExecutions = MaintenanceWindowExecutionListCopier.copyFromBuilder(windowExecutions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowExecutionsResponse build() {
            return new DescribeMaintenanceWindowExecutionsResponse(this);
        }
    }
}
