/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceInformationResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeInstanceInformationResponse.Builder, DescribeInstanceInformationResponse> {
    private final List<InstanceInformation> instanceInformationList;

    private final String nextToken;

    private DescribeInstanceInformationResponse(BuilderImpl builder) {
        super(builder);
        this.instanceInformationList = builder.instanceInformationList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The instance information list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The instance information list.
     */
    public List<InstanceInformation> instanceInformationList() {
        return instanceInformationList;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceInformationList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceInformationResponse)) {
            return false;
        }
        DescribeInstanceInformationResponse other = (DescribeInstanceInformationResponse) obj;
        return Objects.equals(instanceInformationList(), other.instanceInformationList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeInstanceInformationResponse").add("InstanceInformationList", instanceInformationList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceInformationList":
            return Optional.ofNullable(clazz.cast(instanceInformationList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmResponse.Builder, CopyableBuilder<Builder, DescribeInstanceInformationResponse> {
        /**
         * <p>
         * The instance information list.
         * </p>
         * 
         * @param instanceInformationList
         *        The instance information list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInformationList(Collection<InstanceInformation> instanceInformationList);

        /**
         * <p>
         * The instance information list.
         * </p>
         * 
         * @param instanceInformationList
         *        The instance information list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInformationList(InstanceInformation... instanceInformationList);

        /**
         * <p>
         * The instance information list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceInformation>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceInformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceInformationList(List<InstanceInformation>)}.
         * 
         * @param instanceInformationList
         *        a consumer that will call methods on {@link List<InstanceInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceInformationList(List<InstanceInformation>)
         */
        Builder instanceInformationList(Consumer<InstanceInformation.Builder>... instanceInformationList);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<InstanceInformation> instanceInformationList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceInformationResponse model) {
            super(model);
            instanceInformationList(model.instanceInformationList);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceInformation.Builder> getInstanceInformationList() {
            return instanceInformationList != null ? instanceInformationList.stream().map(InstanceInformation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceInformationList(Collection<InstanceInformation> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copy(instanceInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationList(InstanceInformation... instanceInformationList) {
            instanceInformationList(Arrays.asList(instanceInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationList(Consumer<InstanceInformation.Builder>... instanceInformationList) {
            instanceInformationList(Stream.of(instanceInformationList)
                    .map(c -> InstanceInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceInformationList(Collection<InstanceInformation.BuilderImpl> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copyFromBuilder(instanceInformationList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceInformationResponse build() {
            return new DescribeInstanceInformationResponse(this);
        }
    }
}
