/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteParametersResponse extends SsmResponse implements
        ToCopyableBuilder<DeleteParametersResponse.Builder, DeleteParametersResponse> {
    private final List<String> deletedParameters;

    private final List<String> invalidParameters;

    private DeleteParametersResponse(BuilderImpl builder) {
        super(builder);
        this.deletedParameters = builder.deletedParameters;
        this.invalidParameters = builder.invalidParameters;
    }

    /**
     * <p>
     * The names of the deleted parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the deleted parameters.
     */
    public List<String> deletedParameters() {
        return deletedParameters;
    }

    /**
     * <p>
     * The names of parameters that weren't deleted because the parameters are not valid.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of parameters that weren't deleted because the parameters are not valid.
     */
    public List<String> invalidParameters() {
        return invalidParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deletedParameters());
        hashCode = 31 * hashCode + Objects.hashCode(invalidParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteParametersResponse)) {
            return false;
        }
        DeleteParametersResponse other = (DeleteParametersResponse) obj;
        return Objects.equals(deletedParameters(), other.deletedParameters())
                && Objects.equals(invalidParameters(), other.invalidParameters());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteParametersResponse").add("DeletedParameters", deletedParameters())
                .add("InvalidParameters", invalidParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletedParameters":
            return Optional.ofNullable(clazz.cast(deletedParameters()));
        case "InvalidParameters":
            return Optional.ofNullable(clazz.cast(invalidParameters()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SsmResponse.Builder, CopyableBuilder<Builder, DeleteParametersResponse> {
        /**
         * <p>
         * The names of the deleted parameters.
         * </p>
         * 
         * @param deletedParameters
         *        The names of the deleted parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedParameters(Collection<String> deletedParameters);

        /**
         * <p>
         * The names of the deleted parameters.
         * </p>
         * 
         * @param deletedParameters
         *        The names of the deleted parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedParameters(String... deletedParameters);

        /**
         * <p>
         * The names of parameters that weren't deleted because the parameters are not valid.
         * </p>
         * 
         * @param invalidParameters
         *        The names of parameters that weren't deleted because the parameters are not valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameters(Collection<String> invalidParameters);

        /**
         * <p>
         * The names of parameters that weren't deleted because the parameters are not valid.
         * </p>
         * 
         * @param invalidParameters
         *        The names of parameters that weren't deleted because the parameters are not valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameters(String... invalidParameters);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<String> deletedParameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> invalidParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteParametersResponse model) {
            super(model);
            deletedParameters(model.deletedParameters);
            invalidParameters(model.invalidParameters);
        }

        public final Collection<String> getDeletedParameters() {
            return deletedParameters;
        }

        @Override
        public final Builder deletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedParameters(String... deletedParameters) {
            deletedParameters(Arrays.asList(deletedParameters));
            return this;
        }

        public final void setDeletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
        }

        public final Collection<String> getInvalidParameters() {
            return invalidParameters;
        }

        @Override
        public final Builder invalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidParameters(String... invalidParameters) {
            invalidParameters(Arrays.asList(invalidParameters));
            return this;
        }

        public final void setInvalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
        }

        @Override
        public DeleteParametersResponse build() {
            return new DeleteParametersResponse(this);
        }
    }
}
