/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateDocumentRequestModelMarshaller {
    private static final MarshallingInfo<String> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();
    private static final UpdateDocumentRequestModelMarshaller INSTANCE = new UpdateDocumentRequestModelMarshaller();

    private UpdateDocumentRequestModelMarshaller() {
    }

    public static UpdateDocumentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateDocumentRequest updateDocumentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateDocumentRequest), (String)"updateDocumentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateDocumentRequest.content(), CONTENT_BINDING);
            protocolMarshaller.marshall((Object)updateDocumentRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)updateDocumentRequest.documentVersion(), DOCUMENTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

