/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.S3OutputLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3OutputLocationMarshaller {
    private static final MarshallingInfo<String> OUTPUTS3REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3Region").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3BucketName").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3KeyPrefix").isBinary(false).build();
    private static final S3OutputLocationMarshaller INSTANCE = new S3OutputLocationMarshaller();

    private S3OutputLocationMarshaller() {
    }

    public static S3OutputLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3OutputLocation s3OutputLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3OutputLocation, (String)"s3OutputLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3OutputLocation.outputS3Region(), OUTPUTS3REGION_BINDING);
            protocolMarshaller.marshall((Object)s3OutputLocation.outputS3BucketName(), OUTPUTS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3OutputLocation.outputS3KeyPrefix(), OUTPUTS3KEYPREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

