/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MaintenanceWindowExecutionTaskInvocationIdentityMarshaller {
    private static final MarshallingInfo<String> WINDOWEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> TASKEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> INVOCATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvocationId").isBinary(false).build();
    private static final MarshallingInfo<String> EXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskType").isBinary(false).build();
    private static final MarshallingInfo<String> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<String> OWNERINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerInformation").isBinary(false).build();
    private static final MarshallingInfo<String> WINDOWTARGETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTargetId").isBinary(false).build();
    private static final MaintenanceWindowExecutionTaskInvocationIdentityMarshaller INSTANCE = new MaintenanceWindowExecutionTaskInvocationIdentityMarshaller();

    private MaintenanceWindowExecutionTaskInvocationIdentityMarshaller() {
    }

    public static MaintenanceWindowExecutionTaskInvocationIdentityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MaintenanceWindowExecutionTaskInvocationIdentity maintenanceWindowExecutionTaskInvocationIdentity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)maintenanceWindowExecutionTaskInvocationIdentity, (String)"maintenanceWindowExecutionTaskInvocationIdentity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.windowExecutionId(), WINDOWEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.taskExecutionId(), TASKEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.invocationId(), INVOCATIONID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.executionId(), EXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.taskTypeAsString(), TASKTYPE_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.ownerInformation(), OWNERINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecutionTaskInvocationIdentity.windowTargetId(), WINDOWTARGETID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

