/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InventoryItemAttribute;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InventoryItemAttributeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DATATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataType").isBinary(false).build();
    private static final InventoryItemAttributeMarshaller INSTANCE = new InventoryItemAttributeMarshaller();

    private InventoryItemAttributeMarshaller() {
    }

    public static InventoryItemAttributeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InventoryItemAttribute inventoryItemAttribute, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inventoryItemAttribute, (String)"inventoryItemAttribute");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inventoryItemAttribute.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)inventoryItemAttribute.dataTypeAsString(), DATATYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

