/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.GetParametersRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetParametersRequestModelMarshaller {
    private static final MarshallingInfo<List> NAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Names").isBinary(false).build();
    private static final MarshallingInfo<Boolean> WITHDECRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WithDecryption").isBinary(false).build();
    private static final GetParametersRequestModelMarshaller INSTANCE = new GetParametersRequestModelMarshaller();

    private GetParametersRequestModelMarshaller() {
    }

    public static GetParametersRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetParametersRequest getParametersRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getParametersRequest), (String)"getParametersRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(getParametersRequest.names(), NAMES_BINDING);
            protocolMarshaller.marshall((Object)getParametersRequest.withDecryption(), WITHDECRYPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

