/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetInventoryRequestModelMarshaller {
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<List> AGGREGATORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Aggregators").isBinary(false).build();
    private static final MarshallingInfo<List> RESULTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final GetInventoryRequestModelMarshaller INSTANCE = new GetInventoryRequestModelMarshaller();

    private GetInventoryRequestModelMarshaller() {
    }

    public static GetInventoryRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetInventoryRequest getInventoryRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getInventoryRequest), (String)"getInventoryRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(getInventoryRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall(getInventoryRequest.aggregators(), AGGREGATORS_BINDING);
            protocolMarshaller.marshall(getInventoryRequest.resultAttributes(), RESULTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)getInventoryRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)getInventoryRequest.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

