/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.FailureDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FailureDetailsMarshaller {
    private static final MarshallingInfo<String> FAILURESTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureStage").isBinary(false).build();
    private static final MarshallingInfo<String> FAILURETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureType").isBinary(false).build();
    private static final MarshallingInfo<Map> DETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Details").isBinary(false).build();
    private static final FailureDetailsMarshaller INSTANCE = new FailureDetailsMarshaller();

    private FailureDetailsMarshaller() {
    }

    public static FailureDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FailureDetails failureDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)failureDetails, (String)"failureDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)failureDetails.failureStage(), FAILURESTAGE_BINDING);
            protocolMarshaller.marshall((Object)failureDetails.failureType(), FAILURETYPE_BINDING);
            protocolMarshaller.marshall(failureDetails.details(), DETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

