/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CreateAssociationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateAssociationRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEDULEEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduleExpression").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputLocation").isBinary(false).build();
    private static final MarshallingInfo<String> ASSOCIATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationName").isBinary(false).build();
    private static final CreateAssociationRequestModelMarshaller INSTANCE = new CreateAssociationRequestModelMarshaller();

    private CreateAssociationRequestModelMarshaller() {
    }

    public static CreateAssociationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateAssociationRequest createAssociationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createAssociationRequest), (String)"createAssociationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createAssociationRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createAssociationRequest.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)createAssociationRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(createAssociationRequest.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(createAssociationRequest.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)createAssociationRequest.scheduleExpression(), SCHEDULEEXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)createAssociationRequest.outputLocation(), OUTPUTLOCATION_BINDING);
            protocolMarshaller.marshall((Object)createAssociationRequest.associationName(), ASSOCIATIONNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

