/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActivationMarshaller {
    private static final MarshallingInfo<String> ACTIVATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivationId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTINSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultInstanceName").isBinary(false).build();
    private static final MarshallingInfo<String> IAMROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRole").isBinary(false).build();
    private static final MarshallingInfo<Integer> REGISTRATIONLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationLimit").isBinary(false).build();
    private static final MarshallingInfo<Integer> REGISTRATIONSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationsCount").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPIRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationDate").isBinary(false).build();
    private static final MarshallingInfo<Boolean> EXPIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expired").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").isBinary(false).build();
    private static final ActivationMarshaller INSTANCE = new ActivationMarshaller();

    private ActivationMarshaller() {
    }

    public static ActivationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Activation activation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)activation, (String)"activation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)activation.activationId(), ACTIVATIONID_BINDING);
            protocolMarshaller.marshall((Object)activation.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)activation.defaultInstanceName(), DEFAULTINSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)activation.iamRole(), IAMROLE_BINDING);
            protocolMarshaller.marshall((Object)activation.registrationLimit(), REGISTRATIONLIMIT_BINDING);
            protocolMarshaller.marshall((Object)activation.registrationsCount(), REGISTRATIONSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activation.expirationDate(), EXPIRATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)activation.expired(), EXPIRED_BINDING);
            protocolMarshaller.marshall((Object)activation.createdDate(), CREATEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

