/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ssm.SSMAsyncClient;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;

public class GetParameterHistoryPublisher
implements SdkPublisher<GetParameterHistoryResponse> {
    private final SSMAsyncClient client;
    private final GetParameterHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetParameterHistoryPublisher(SSMAsyncClient client, GetParameterHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetParameterHistoryPublisher(SSMAsyncClient client, GetParameterHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetParameterHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetParameterHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetParameterHistoryPublisher resume(GetParameterHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetParameterHistoryPublisher(this.client, (GetParameterHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetParameterHistoryPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetParameterHistoryResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetParameterHistoryResponseFetcher
    implements AsyncPageFetcher<GetParameterHistoryResponse> {
        private GetParameterHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetParameterHistoryResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetParameterHistoryResponse> nextPage(GetParameterHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetParameterHistoryPublisher.this.client.getParameterHistory(GetParameterHistoryPublisher.this.firstRequest);
            }
            return GetParameterHistoryPublisher.this.client.getParameterHistory((GetParameterHistoryRequest)((Object)GetParameterHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

