/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ssm.SSMAsyncClient;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;

public class DescribeInstanceInformationPublisher
implements SdkPublisher<DescribeInstanceInformationResponse> {
    private final SSMAsyncClient client;
    private final DescribeInstanceInformationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceInformationPublisher(SSMAsyncClient client, DescribeInstanceInformationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceInformationPublisher(SSMAsyncClient client, DescribeInstanceInformationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceInformationResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceInformationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<InstanceInformation> instanceInformationList() {
        Function<DescribeInstanceInformationResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceInformationList() != null) {
                return response.instanceInformationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeInstanceInformationResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeInstanceInformationPublisher resume(DescribeInstanceInformationResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeInstanceInformationPublisher(this.client, (DescribeInstanceInformationRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeInstanceInformationPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeInstanceInformationResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeInstanceInformationResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceInformationResponse> {
        private DescribeInstanceInformationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceInformationResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeInstanceInformationResponse> nextPage(DescribeInstanceInformationResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceInformationPublisher.this.client.describeInstanceInformation(DescribeInstanceInformationPublisher.this.firstRequest);
            }
            return DescribeInstanceInformationPublisher.this.client.describeInstanceInformation((DescribeInstanceInformationRequest)((Object)DescribeInstanceInformationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

