/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterTargetWithMaintenanceWindowRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, RegisterTargetWithMaintenanceWindowRequest> {
    private final String windowId;
    private final String resourceType;
    private final List<Target> targets;
    private final String ownerInformation;
    private final String name;
    private final String description;
    private final String clientToken;

    private RegisterTargetWithMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.resourceType = builder.resourceType;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
        this.name = builder.name;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    public String windowId() {
        return this.windowId;
    }

    public MaintenanceWindowResourceType resourceType() {
        return MaintenanceWindowResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String ownerInformation() {
        return this.ownerInformation;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetWithMaintenanceWindowRequest)) {
            return false;
        }
        RegisterTargetWithMaintenanceWindowRequest other = (RegisterTargetWithMaintenanceWindowRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.ownerInformation(), other.ownerInformation()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"RegisterTargetWithMaintenanceWindowRequest").add("WindowId", (Object)this.windowId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Targets", this.targets()).add("OwnerInformation", (Object)this.ownerInformation()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.of(clazz.cast(this.windowId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceTypeAsString()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "OwnerInformation": {
                return Optional.of(clazz.cast(this.ownerInformation()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String windowId;
        private String resourceType;
        private List<Target> targets;
        private String ownerInformation;
        private String name;
        private String description;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTargetWithMaintenanceWindowRequest model) {
            super(model);
            this.windowId(model.windowId);
            this.resourceType(model.resourceType);
            this.targets(model.targets);
            this.ownerInformation(model.ownerInformation);
            this.name(model.name);
            this.description(model.description);
            this.clientToken(model.clientToken);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MaintenanceWindowResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterTargetWithMaintenanceWindowRequest build() {
            return new RegisterTargetWithMaintenanceWindowRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, RegisterTargetWithMaintenanceWindowRequest> {
        public Builder windowId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(MaintenanceWindowResourceType var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder ownerInformation(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

