/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ParametersFilterKey;
import software.amazon.awssdk.services.ssm.model.ParametersFilterValueListCopier;
import software.amazon.awssdk.services.ssm.transform.ParametersFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParametersFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, ParametersFilter> {
    private final String key;
    private final List<String> values;

    private ParametersFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
    }

    public ParametersFilterKey key() {
        return ParametersFilterKey.fromValue(this.key);
    }

    public String keyAsString() {
        return this.key;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParametersFilter)) {
            return false;
        }
        ParametersFilter other = (ParametersFilter)obj;
        return Objects.equals(this.keyAsString(), other.keyAsString()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"ParametersFilter").add("Key", (Object)this.keyAsString()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.of(clazz.cast(this.keyAsString()));
            }
            case "Values": {
                return Optional.of(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParametersFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(ParametersFilter model) {
            this.key(model.key);
            this.values(model.values);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(ParametersFilterKey key) {
            this.key(key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ParametersFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ParametersFilterValueListCopier.copy(values);
        }

        public ParametersFilter build() {
            return new ParametersFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParametersFilter> {
        public Builder key(String var1);

        public Builder key(ParametersFilterKey var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

