/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InventoryItemAttribute;
import software.amazon.awssdk.services.ssm.model.InventoryItemAttributeListCopier;
import software.amazon.awssdk.services.ssm.transform.InventoryItemSchemaMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryItemSchema
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryItemSchema> {
    private final String typeName;
    private final String version;
    private final List<InventoryItemAttribute> attributes;
    private final String displayName;

    private InventoryItemSchema(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.version = builder.version;
        this.attributes = builder.attributes;
        this.displayName = builder.displayName;
    }

    public String typeName() {
        return this.typeName;
    }

    public String version() {
        return this.version;
    }

    public List<InventoryItemAttribute> attributes() {
        return this.attributes;
    }

    public String displayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryItemSchema)) {
            return false;
        }
        InventoryItemSchema other = (InventoryItemSchema)obj;
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.displayName(), other.displayName());
    }

    public String toString() {
        return ToString.builder((String)"InventoryItemSchema").add("TypeName", (Object)this.typeName()).add("Version", (Object)this.version()).add("Attributes", this.attributes()).add("DisplayName", (Object)this.displayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.of(clazz.cast(this.typeName()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryItemSchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String version;
        private List<InventoryItemAttribute> attributes;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryItemSchema model) {
            this.typeName(model.typeName);
            this.version(model.version);
            this.attributes(model.attributes);
            this.displayName(model.displayName);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<InventoryItemAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(InventoryItemAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<InventoryItemAttribute> attributes) {
            this.attributes = InventoryItemAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(InventoryItemAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<InventoryItemAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (InventoryItemAttribute)((InventoryItemAttribute.Builder)InventoryItemAttribute.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<InventoryItemAttribute.BuilderImpl> attributes) {
            this.attributes = InventoryItemAttributeListCopier.copyFromBuilder(attributes);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public InventoryItemSchema build() {
            return new InventoryItemSchema(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryItemSchema> {
        public Builder typeName(String var1);

        public Builder version(String var1);

        public Builder attributes(Collection<InventoryItemAttribute> var1);

        public Builder attributes(InventoryItemAttribute ... var1);

        public Builder attributes(Consumer<InventoryItemAttribute.Builder> ... var1);

        public Builder displayName(String var1);
    }
}

