/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowFilter;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowsRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowsRequest> {
    private final List<MaintenanceWindowFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeMaintenanceWindowsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowFilter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowsRequest)) {
            return false;
        }
        DescribeMaintenanceWindowsRequest other = (DescribeMaintenanceWindowsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowsRequest").add("Filters", this.filters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowFilter> filters;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowsRequest model) {
            super(model);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(MaintenanceWindowFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<MaintenanceWindowFilter> filters) {
            this.filters = MaintenanceWindowFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(MaintenanceWindowFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<MaintenanceWindowFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (MaintenanceWindowFilter)((MaintenanceWindowFilter.Builder)MaintenanceWindowFilter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<MaintenanceWindowFilter.BuilderImpl> filters) {
            this.filters = MaintenanceWindowFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeMaintenanceWindowsRequest build() {
            return new DescribeMaintenanceWindowsRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, DescribeMaintenanceWindowsRequest> {
        public Builder filters(Collection<MaintenanceWindowFilter> var1);

        public Builder filters(MaintenanceWindowFilter ... var1);

        public Builder filters(Consumer<MaintenanceWindowFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

