/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter;
import software.amazon.awssdk.services.ssm.model.InstancePatchStateFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancePatchStatesForPatchGroupRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
    private final String patchGroup;
    private final List<InstancePatchStateFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeInstancePatchStatesForPatchGroupRequest(BuilderImpl builder) {
        super(builder);
        this.patchGroup = builder.patchGroup;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String patchGroup() {
        return this.patchGroup;
    }

    public List<InstancePatchStateFilter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchStatesForPatchGroupRequest)) {
            return false;
        }
        DescribeInstancePatchStatesForPatchGroupRequest other = (DescribeInstancePatchStatesForPatchGroupRequest)((Object)obj);
        return Objects.equals(this.patchGroup(), other.patchGroup()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstancePatchStatesForPatchGroupRequest").add("PatchGroup", (Object)this.patchGroup()).add("Filters", this.filters()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PatchGroup": {
                return Optional.of(clazz.cast(this.patchGroup()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String patchGroup;
        private List<InstancePatchStateFilter> filters;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchStatesForPatchGroupRequest model) {
            super(model);
            this.patchGroup(model.patchGroup);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getPatchGroup() {
            return this.patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final Collection<InstancePatchStateFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(InstancePatchStateFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<InstancePatchStateFilter> filters) {
            this.filters = InstancePatchStateFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InstancePatchStateFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<InstancePatchStateFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (InstancePatchStateFilter)((InstancePatchStateFilter.Builder)InstancePatchStateFilter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<InstancePatchStateFilter.BuilderImpl> filters) {
            this.filters = InstancePatchStateFilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancePatchStatesForPatchGroupRequest build() {
            return new DescribeInstancePatchStatesForPatchGroupRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
        public Builder patchGroup(String var1);

        public Builder filters(Collection<InstancePatchStateFilter> var1);

        public Builder filters(InstancePatchStateFilter ... var1);

        public Builder filters(Consumer<InstancePatchStateFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

