/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ComplianceItemDetailsCopier;
import software.amazon.awssdk.services.ssm.model.ComplianceSeverity;
import software.amazon.awssdk.services.ssm.model.ComplianceStatus;
import software.amazon.awssdk.services.ssm.transform.ComplianceItemEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceItemEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceItemEntry> {
    private final String id;
    private final String title;
    private final String severity;
    private final String status;
    private final Map<String, String> details;

    private ComplianceItemEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.severity = builder.severity;
        this.status = builder.status;
        this.details = builder.details;
    }

    public String id() {
        return this.id;
    }

    public String title() {
        return this.title;
    }

    public ComplianceSeverity severity() {
        return ComplianceSeverity.fromValue(this.severity);
    }

    public String severityAsString() {
        return this.severity;
    }

    public ComplianceStatus status() {
        return ComplianceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Map<String, String> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceItemEntry)) {
            return false;
        }
        ComplianceItemEntry other = (ComplianceItemEntry)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.details(), other.details());
    }

    public String toString() {
        return ToString.builder((String)"ComplianceItemEntry").add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).add("Details", this.details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Title": {
                return Optional.of(clazz.cast(this.title()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severityAsString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "Details": {
                return Optional.of(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceItemEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String title;
        private String severity;
        private String status;
        private Map<String, String> details;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceItemEntry model) {
            this.id(model.id);
            this.title(model.title);
            this.severity(model.severity);
            this.status(model.status);
            this.details(model.details);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ComplianceSeverity severity) {
            this.severity(severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(Map<String, String> details) {
            this.details = ComplianceItemDetailsCopier.copy(details);
            return this;
        }

        public final void setDetails(Map<String, String> details) {
            this.details = ComplianceItemDetailsCopier.copy(details);
        }

        public ComplianceItemEntry build() {
            return new ComplianceItemEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceItemEntry> {
        public Builder id(String var1);

        public Builder title(String var1);

        public Builder severity(String var1);

        public Builder severity(ComplianceSeverity var1);

        public Builder status(String var1);

        public Builder status(ComplianceStatus var1);

        public Builder details(Map<String, String> var1);
    }
}

