/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateMaintenanceWindowTargetRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateMaintenanceWindowTargetRequestModelMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").isBinary(false).build();

    private static final MarshallingInfo<String> WINDOWTARGETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTargetId").isBinary(false).build();

    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();

    private static final MarshallingInfo<String> OWNERINFORMATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerInformation").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REPLACE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Replace").isBinary(false).build();

    private static final UpdateMaintenanceWindowTargetRequestModelMarshaller INSTANCE = new UpdateMaintenanceWindowTargetRequestModelMarshaller();

    private UpdateMaintenanceWindowTargetRequestModelMarshaller() {
    }

    public static UpdateMaintenanceWindowTargetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateMaintenanceWindowTargetRequest updateMaintenanceWindowTargetRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateMaintenanceWindowTargetRequest, "updateMaintenanceWindowTargetRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateMaintenanceWindowTargetRequest.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTargetRequest.windowTargetId(), WINDOWTARGETID_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTargetRequest.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTargetRequest.ownerInformation(), OWNERINFORMATION_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTargetRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTargetRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTargetRequest.replace(), REPLACE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
